//+-----------+
//| TwoPerBar |
//+-----------+
#property copyright "Ron Thompson"
#property link      "http://www.lightpatch.com/forex/"
 
#property indicator_chart_window
#property indicator_buffers 2
#property indicator_color1 DodgerBlue
#property indicator_color2 Magenta

extern double BDistance    =      14;    // plus how much
extern int    BPeriod      =      15;    // Bollinger period
extern int    Deviation    =       2;    // Bollinger deviation

//---- buffers
double val1[];
double val2[];
 

//+----------------+
//| Custom init    |
//+----------------+
int init()
  {
   IndicatorBuffers(2);
   
   SetIndexStyle(0,DRAW_ARROW);
   SetIndexArrow(0,233);
   SetIndexBuffer(0,val1);
   
   SetIndexStyle(1,DRAW_ARROW);
   SetIndexArrow(1,234);
   SetIndexBuffer(1,val2);
  }
  
//+----------------+
//| Custom DE-init |
//+----------------+
int deinit()
  {
   Print("DE-Init happened ",CurTime());
   Comment(" ");
  }

  
//+-----+
//| TPB |
//+-----+
int start()
  {   
   
   int i;
   int mybars=Bars;

	double ma = iMA(Symbol(),0,BPeriod,0,MODE_SMA,PRICE_OPEN,0);
	double stddev = iStdDev(Symbol(),0,BPeriod,0,MODE_SMA,PRICE_OPEN,0);   
   double bup0 = ma+(Deviation*stddev);
   double bdn0 = ma-(Deviation*stddev);

      
   for (i=mybars; i>=0; i--) 
     { 
      ma = iMA(Symbol(),0,BPeriod,0,MODE_SMA,PRICE_OPEN,i);
	   stddev = iStdDev(Symbol(),0,BPeriod,0,MODE_SMA,PRICE_OPEN,i);   
      bup0 = ma+(Deviation*stddev);
      bdn0 = ma-(Deviation*stddev);

      if( High[i]>=bup0+(BDistance*Point) )
        {
         val2[i]=bup0+(BDistance*Point);         
        }
      if( Low[i]<=bdn0-(BDistance*Point) )
        {
         val1[i]=bdn0-(BDistance*Point);         
        }
 
     }//for
   
 
  }//start
  

